<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Billet</title>
    <link href="CSS/billetlogue.css" rel="stylesheet">
</head>
<body>
<header>
    <div class="logo"><a href="utilisateurlogue.php">Blogies</a></div>
    <div class="nav-buttons">
        <a class="deco" href="utilisateurlogue.php">Accueil</a>
        <a class="deco" href="deco.php">Déconnexion</a>
        <?php
        include("connexion.php");
        $stmt = $db->prepare("SELECT photo_profil FROM utilisateurs WHERE login = :login");
        $stmt->bindValue(':login', $_SESSION['login'], PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $photo_profil = $result['photo_profil'] ?? "uploads/default.avif";
        echo "<a href='pp.php'><img src='" . htmlspecialchars($photo_profil) . "' class='photo-profil' alt='Photo de profil' style='width:40px;height:40px;border-radius:50%;'></a>";
        ?>
    </div>
</header>

<main>

    <?php
    if (!isset($_SESSION['login'])) {
        echo "<p>Vous devez être connecté pour voir les billets.</p>";
        exit();
    }

    $billet_id = $_GET['id'];
    $stmt = $db->prepare("SELECT * FROM billets WHERE id = :id_billet");
    $stmt->bindValue(':id_billet', $billet_id, PDO::PARAM_INT);
    $stmt->execute();
    $billet = $stmt->fetch(PDO::FETCH_ASSOC);

    echo "<div class='billet-details'>
            <h2>{$billet['titre']}</h2>
            <p><strong>Posté le :</strong> {$billet['date_post']}</p>
            <p><strong>Auteur :</strong> {$billet['auteur']}</p>
            <p>{$billet['contenu']}</p>
          </div>";

    $comment_stmt = $db->prepare("SELECT * FROM commentaires WHERE id_billet = :id_billet");
    $comment_stmt->bindValue(':id_billet', $billet_id, PDO::PARAM_INT);
    $comment_stmt->execute();
    $comments = $comment_stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<div class='comments-section'>
            <h4>Commentaires :</h4>";
    if (count($comments) > 0) {
        foreach ($comments as $comment) {
            echo "<div class='comment'>
                    <h5>" . htmlspecialchars($comment['auteur']) . "</h5>
                    <p><em>Posté le : " . htmlspecialchars($comment['date_post']) . "</em></p>
                    <p>" . nl2br(htmlspecialchars($comment['contenu'])) . "</p>
                  </div>";
        }
    } else {
        echo "<p>Aucun commentaire pour ce billet.</p>";
    }
    echo "</div>";

    echo "<form action='billetslogue.php?id={$billet_id}' method='post'>
          <label for='commentaire'>Ajouter un commentaire :</label>
          <textarea id='commentaire' name='commentaire'></textarea>
          <input type='submit' value='Envoyer'>
          <button type='button' onclick='window.history.back();'>Retour</button>
          </form>";

          if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $commentaire = $_POST["commentaire"];

        $stmt = $db->prepare("INSERT INTO commentaires (id_billet, auteur, contenu, date_post) VALUES (:id_billet, :auteur, :contenu, NOW())");
        $stmt->bindValue(':id_billet', $billet_id, PDO::PARAM_INT);
        $stmt->bindValue(':auteur', $_SESSION['login'], PDO::PARAM_STR);
        $stmt->bindValue(':contenu', $commentaire, PDO::PARAM_STR); 
        $stmt->execute();

        echo "Commentaire ajouté avec succès !";
    }
    ?>
</main>
</body>
</html>
